<!-- Main content -->
<x-admin.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuOpen>{{ $data['menuOpen'] }} </x-slot:menuOpen>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:page>{{ $data['page'] }}</x-slot:page>
    <x-slot:head>
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/sweetalert2/sweetalert2.min.css">
    </x-slot:head>


    <section class="content">

        <!-- Default box -->
        <div class="row">
            <div class="col-lg-12">
                <x-message></x-message>
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-server text-primary"></i> {{ $data['page'] }}</h3>
                    </div>
                    <div class="card-body">
                        <form class="form-inline float-right">
                            <input class="form-control mr-sm-2" type="search" placeholder="Search" aria-label="Search"
                                name="cari">
                            <button class="btn btn-primary " type="submit"> <i class="fa fa-search mr-2"></i>
                                Cari!</button>
                        </form>

                        <button class="btn btn-default shadow-sm">
                            <div class="icheck-blue d-inline " style="margin-right: -7px">
                                <input type="checkbox" id="cekall">
                                <label for="cekall">
                                </label>
                            </div>
                        </button>
                        <button class="btn btn-danger" id="pilih_hapus"><i class="fa fa-trash"></i>
                            Hapus</button>

                        <table class="table table-bordered table-hover  tab mt-2">
                            <thead>
                                <tr>
                                    <th width="3%">No</th>
                                    <th>#</th>
                                    <th width="5%">Gambar</th>
                                    <th>Nama Item</th>
                                    <th>Poin Tukar</th>
                                    <th>Member</th>
                                    <th>Ptg. Entry</th>
                                    <th>Tgl. Tukar</th>
                                </tr>
                            </thead>
                            <tbody id="view">
                                @forelse ($poin as $p)
                                    <tr>
                                        <td class="text-center">{{ $no++ }}</td>
                                        <td class="text-center">
                                            <div class="icheck-blue d-inline " style="margin-right: -7px">
                                                <input type="checkbox" name="id[]" id="cek{{ $p->id }}"
                                                    class="ceklis" value="{{ $p->id }}">
                                                <label for="cek{{ $p->id }}">
                                                </label>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <img alt="Avatar" class="table-avatar"
                                                src="{{ asset('/storage/produk/' . hadiah($p->kodetran)->gambar) }}"
                                                width="40px">
                                        </td>
                                        <td>{{ hadiah($p->kodetran)->nm_hadiah }}</td>
                                        <td class="text-center">{{ hadiah($p->kodetran)->poin }} Poin</td>
                                        <td>{{ $p->member->nm_member }}</td>
                                        <td>{{ $p->user->nm_user }}</td>
                                        <td>{{ tgl_inf($p->created_at) }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="20" class="text-center">Data masih kosong</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                        {{ $poin->links('components.admin.pagination') }}
                    </div>
                </div>
            </div>


        </div>
        <!-- /.card -->

    </section>


    <x-slot:foot>

        <script src="{{ asset('') }}assets/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script src="{{ asset('') }}assets/admin/plugins/toastr/toastr.min.js"></script>
        <script src="{{ asset('assets/admin/') }}/tukar.js"></script>
    </x-slot:foot>
</x-admin.contents>
